package gov.va.med.mhv.sm.admin.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.sm.admin.enums.ClinicianStatusEnum;

@Entity
@Table(name = "SECURE_MESSAGE")
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true) 
public class Message extends AbstractBaseEntity{

	private static final long serialVersionUID = 280092511772921884L;
	
	@Id
	@Column(name = "SECURE_MESSAGE_ID")
	
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	//@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;

	@OneToMany(mappedBy="message",cascade=CascadeType.ALL)
	private Set<Addressee> addressees;

	/*@ManyToOne
	@JoinColumn(name = "ASSIGNED_TO")
	private Clinician assignedTo;*/

	@Column(name = "ASSIGNED_TO", insertable = false, updatable = false)
	private Long assignedToUserId;

	@Column(name = "HAS_ATTACHMENT", precision=1, scale=0)
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private boolean attachment;

	@Column(name = "ATTACHMENT_ID")
	private Long attachmentId;
	
	@Column(name = "ATTACHMENT2_ID")
	private Long attachmentId2;
	
	@Column(name = "ATTACHMENT3_ID")
	private Long attachmentId3;
	
	@Column(name = "ATTACHMENT4_ID")
	private Long attachmentId4;
	
	@Column(name = "BODY")
	private String body;	
	
	@Transient
	private Long ccRecipientId;
	
	@Transient
	private String ccRecipientName;	
	
	@Column(name = "CHECKSUM")
	private String checksum;
	
	@Column(name = "COMPLETED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date completedDate;
	
	@Column(name = "CPRSNOTES_FAILED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date cprsNotesFailedDate;
	
	@Column(name = "CPRSNOTES_STATUS")
	private String cprsNotesStatus;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "ESCALATED")
	@Temporal(TemporalType.TIMESTAMP)
	private Date escalatedDate;
	
	@Column(name = "ESCALATION_NOTIFICATION_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date escalationNotificationDate;
	
	@Column(name = "ESCALATION_NOTIFICATION_TRIES")
	private Long escalationNotificationTries;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "READ_RECEIPT")
	private String readReceipt;
	
	@Column(name = "RECIPIENT_ID")
	private Long recipientId;

	@Column(name = "RECIPIENT_NAME")
	private String recipientName;

	@Column(name = "RECIPIENT_TYPE")
	private Long recipientType;

	@Column(name = "CLINICIAN_STATUS")
	private Long status;

	@Column(name = "SENDER_ID")
	private Long senderId;

	@Column(name = "SENDER_NAME")
	private String senderName;

	@Column(name = "SENDER_TYPE")
	private Long senderType;
	
	@Column(name = "SENT_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date sentDate;
	
	@Column(name = "SENT_DATE_LOCAL")
	@Temporal(TemporalType.TIMESTAMP)
	private Date sentDateLocal;
	
	@Column(name = "STATUS_SET_BY", insertable = false, updatable = false)
	private Long statusSetBy;

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "THREAD_ID")
	private Thread thread;
	
	@Column(name = "THREAD_ID", insertable = false, updatable = false)
	private Long threadId;

	public Message(){
		this.active=true;
		this.createdDate = new Date();
		this.modifiedDate = new Date();
		this.status = ClinicianStatusEnum.INCOMPLETE.getId();		
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Set<Addressee> getAddressees() {
		return addressees;
	}

	public void setAddressees(Set<Addressee> addressees) {
		this.addressees = addressees;
	}
	
	/*public Clinician getAssignedTo() {
		return assignedTo;
	}

	public void setAssignedTo(Clinician assignedTo) {
		this.assignedTo = assignedTo;
	}*/

	public Long getAssignedToUserId() {
		return assignedToUserId;
	}

	public void setAssignedToUserId(Long assignedToUserId) {
		this.assignedToUserId = assignedToUserId;
	}

	public Long getAttachmentId() {
		return attachmentId;
	}

	public void setAttachmentId(Long attachmentId) {
		this.attachmentId = attachmentId;
	}

	public Long getAttachmentId2() {
		return attachmentId2;
	}

	public void setAttachmentId2(Long attachmentId2) {
		this.attachmentId2 = attachmentId2;
	}

	public Long getAttachmentId3() {
		return attachmentId3;
	}

	public void setAttachmentId3(Long attachmentId3) {
		this.attachmentId3 = attachmentId3;
	}

	public Long getAttachmentId4() {
		return attachmentId4;
	}

	public void setAttachmentId4(Long attachmentId4) {
		this.attachmentId4 = attachmentId4;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public Long getCcRecipientId() {
		return ccRecipientId;
	}

	public void setCcRecipientId(Long ccRecipientId) {
		this.ccRecipientId = ccRecipientId;
	}

	public String getCcRecipientName() {
		return ccRecipientName;
	}

	public void setCcRecipientName(String ccRecipientName) {
		this.ccRecipientName = ccRecipientName;
	}

	public String getChecksum() {
		return checksum;
	}

	public void setChecksum(String checksum) {
		this.checksum = checksum;
	}

	public Date getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}

	public Date getCprsNotesFailedDate() {
		return cprsNotesFailedDate;
	}

	public void setCprsNotesFailedDate(Date cprsNotesFailedDate) {
		this.cprsNotesFailedDate = cprsNotesFailedDate;
	}

	public String getCprsNotesStatus() {
		return cprsNotesStatus;
	}

	public void setCprsNotesStatus(String cprsNotesStatus) {
		this.cprsNotesStatus = cprsNotesStatus;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getEscalatedDate() {
		return escalatedDate;
	}

	public void setEscalatedDate(Date escalatedDate) {
		this.escalatedDate = escalatedDate;
	}

	public Date getEscalationNotificationDate() {
		return escalationNotificationDate;
	}

	public void setEscalationNotificationDate(Date escalationNotificationDate) {
		this.escalationNotificationDate = escalationNotificationDate;
	}

	public Long getEscalationNotificationTries() {
		return escalationNotificationTries;
	}

	public void setEscalationNotificationTries(Long escalationNotificationTries) {
		this.escalationNotificationTries = escalationNotificationTries;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getReadReceipt() {
		return readReceipt;
	}

	public void setReadReceipt(String readReceipt) {
		this.readReceipt = readReceipt;
	}

	public Long getRecipientId() {
		return recipientId;
	}

	public void setRecipientId(Long recipientId) {
		this.recipientId = recipientId;
	}

	public String getRecipientName() {
		return recipientName;
	}

	public void setRecipientName(String recipientName) {
		this.recipientName = recipientName;
	}

	public Long getRecipientType() {
		return recipientType;
	}

	public void setRecipientType(Long recipientType) {
		this.recipientType = recipientType;
	}

	public Long getStatus() {
		return status;
	}

	public void setStatus(Long status) {
		this.status = status;
	}

	public Long getSenderId() {
		return senderId;
	}

	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}

	public String getSenderName() {
		return senderName;
	}

	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public Long getSenderType() {
		return senderType;
	}

	public void setSenderType(Long senderType) {
		this.senderType = senderType;
	}

	public Date getSentDate() {
		return sentDate;
	}

	public void setSentDate(Date sentDate) {
		this.sentDate = sentDate;
	}

	public Date getSentDateLocal() {
		return sentDateLocal;
	}

	public void setSentDateLocal(Date sentDateLocal) {
		this.sentDateLocal = sentDateLocal;
	}

	public Long getStatusSetBy() {
		return statusSetBy;
	}

	public void setStatusSetBy(Long statusSetBy) {
		this.statusSetBy = statusSetBy;
	}

	public Thread getThread() {
		return thread;
	}

	public void setThread(Thread thread) {
		this.thread = thread;
	}

	public Long getThreadId() {
		return threadId;
	}

	public void setThreadId(Long threadId) {
		this.threadId = threadId;
	}

	public boolean isAttachment() {
		return attachment;
	}

	public void setAttachment(boolean attachment) {
		this.attachment = attachment;
	}
	
}
